//
//  MCReportChoosePrintTemplate.h
//  MCReporting
//
//  Created by Alykhan Jetha on 10/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>

@class MCSplitView;
@class MCScalingScrollView;
@class MCWebKitTemplateView;
@class MCTextTemplateView;

@class MCSimpleBox;

@interface MCReportWhiteBox : NSView

@end


@interface MCReportChoosePrintTemplate : MCWindowController {
	BOOL shouldAutorelease;
	BOOL isEditingField;
	int currentPageCount;
	
	NSArray *selectedObjects;
	NSArray *allObjects;
	NSArray *behaviors;
	NSString *typeIdentifier;
	NSDictionary *extraArguments;
	
	NSString *generatedHTML; // keeping the generated content in the event the user wants to save it
	
	NSDocument *referringDocument;  // weak ref
	NSWindow *referringWindow; // weak ref

	IBOutlet MCSplitView *splitView;
	IBOutlet NSTableView *sourceList;
	IBOutlet NSTabView *tabView;
	IBOutlet NSArrayController *templatesAC;
	IBOutlet MCReportWhiteBox *whiteBox;
	IBOutlet NSProgressIndicator *wheelIndicator; // we don't use super's because that's a bar
	IBOutlet NSTextField *selectField;
	IBOutlet MCScalingScrollView *scalingScrollView;
	IBOutlet MCWebKitTemplateView *webTemplateView;
	IBOutlet MCTextTemplateView *textTemplateView;
	
	IBOutlet NSButton *printButton;
	IBOutlet NSButton *saveAsButton;
	IBOutlet NSMatrix *scopeMatrix;
	
	IBOutlet NSView *labelSheetAccessoryView;
	IBOutlet NSTextField *labelStartPositionField;
	IBOutlet NSTextField *labelDuplicatesField;
	
}

+ (void)runChoosePrintTemplateForSelectedObjects:(NSArray *)selection 
									  allObjects:(NSArray *)all 
										document:(NSDocument *)aDoc 
										inWindow:(NSWindow *)aWindow
									   behaviors:(NSArray *)aBehaviors 
								  typeIdentifier:(NSString *)aTypeName
								 passOnArguments:(NSDictionary *)arguments;


- (BOOL)shouldAutorelease;
- (void)setShouldAutorelease:(BOOL)flag;

- (NSArray *)selectedObjects;
- (void)setSelectedObjects:(NSArray *)aSelectedObjects;

- (NSArray *)allObjects;
- (void)setAllObjects:(NSArray *)anAllObjects;

- (NSArray *)behaviors;
- (void)setBehaviors:(NSArray *)aBehaviors;

- (NSDocument *)referringDocument;
- (void)setReferringDocument:(NSDocument *)aReferringDocument;

- (NSWindow *)referringWindow;
- (void)setReferringWindow:(NSWindow *)aReferringWindow;

- (NSString *)generatedHTML;
- (void)setGeneratedHTML:(NSString *)aGeneratedHTML;


/*
 Used to narrow the 'area'. In merge cases, it is the MCEntityName, in the new report stuff it is the applicable area
 */
- (NSString *)typeIdentifier;
- (void)setTypeIdentifier:(NSString *)aTypeIdentifier;

/*
 Use this to pass additional arguments - such a 'form'
 */
- (NSDictionary *)extraArguments;
- (void)setExtraArguments:(NSDictionary *)anExtraArguments;

- (void)configureScopeMatrix;

- (void)loadTemplates;

- (IBAction)generatePreview:(id)sender;

- (IBAction)print:(id)sender;
- (IBAction)cancel:(id)sender;
- (IBAction)saveAs:(id)sender;
- (IBAction)scopeChanged:(id)sender;
- (IBAction)editReport:(id)sender;

@end
